import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(14, 4))

# Define colors for clear and not clear statuses
clear_color = 'green'
not_clear_color = 'red'
text_color = 'white'

# Define positions for curbs
curb_positions = [(i * 2, 0) for i in range(7)]

# Define car and curb data for the goal state
curbs = [
    {'label': 'curb_0', 'car1': 'car0\nnot clear', 'car2': 'car7\nclear', 'color1': not_clear_color, 'color2': clear_color},
    {'label': 'curb_1', 'car1': 'car1\nnot clear', 'car2': 'car8\nclear', 'color1': not_clear_color, 'color2': clear_color},
    {'label': 'curb_2', 'car1': 'car2\nnot clear', 'car2': 'car9\nclear', 'color1': not_clear_color, 'color2': clear_color},
    {'label': 'curb_3', 'car1': 'car3\nclear', 'car2': None, 'color1': clear_color, 'color2': None},
    {'label': 'curb_4', 'car1': 'car4\nclear', 'car2': None, 'color1': clear_color, 'color2': None},
    {'label': 'curb_5', 'car1': 'car5\nclear', 'car2': None, 'color1': clear_color, 'color2': None},
    {'label': 'curb_6', 'car1': 'car6\nclear', 'car2': None, 'color1': clear_color, 'color2': None}
]

# Draw curbs and cars
for i, curb in enumerate(curbs):
    x, y = curb_positions[i]
    # Draw curb
    ax.add_patch(patches.Rectangle((x, y), 1.5, 2, edgecolor='black', facecolor='lightgray'))
    # Draw first car
    ax.add_patch(patches.Rectangle((x + 0.1, y + 0.1), 1.3, 0.8, edgecolor='black', facecolor=curb['color1']))
    ax.text(x + 0.75, y + 0.5, curb['car1'], ha='center', va='center', color=text_color)
    # Draw second car if exists
    if curb['car2']:
        ax.add_patch(patches.Rectangle((x + 0.1, y + 1.1), 1.3, 0.8, edgecolor='black', facecolor=curb['color2']))
        ax.text(x + 0.75, y + 1.5, curb['car2'], ha='center', va='center', color=text_color)
    # Label curb
    ax.text(x + 0.75, y - 0.3, curb['label'], ha='center', va='center', color='black')

# Add legend
legend_patches = [
    patches.Patch(color=clear_color, label='Clear'),
    patches.Patch(color=not_clear_color, label='Not Clear')
]
plt.legend(handles=legend_patches, loc='upper right', bbox_to_anchor=(1.1, 1))

# Set limits and remove axes
ax.set_xlim(-1, 14)
ax.set_ylim(-1, 3)
ax.axis('off')

# Save the figure
plt.savefig('parking/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_18.png', bbox_inches='tight')
plt.show()